USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_GetUserRewardPointsTotal]    Script Date: 8/27/2013 2:32:28 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-22>
-- Description:	<Get total rewards points for a User via UserID>
-- =============================================
CREATE PROCEDURE [dbo].[RP_GetUserRewardPointsTotal]
	-- Add the parameters for the stored procedure here
	@UserID int = 0, @userTotalPoints money OUTPUT
AS

BEGIN
	SET NOCOUNT ON;

     SELECT @userTotalPoints = (SELECT SUM(PointChange) AS UserTotalPoints FROM [dbo].[RewardTransaction] WHERE UserID = @UserID);
	 
	 -- do not return null (say like new user in program and doesn't have any points ) return ZERO
	 IF @userTotalPoints IS NULL
		SELECT @userTotalPoints = 0;

END

GO


